
import cadquery as cq

# Defining the points to create a proper L-shaped sketch
points = [(0, 0), (0, 10), (2, 10), (2, 2), (10, 2), (10, 0)]

# Creating a workplane to draw the polyline that form an "L"
r = cq.Workplane("front").polyline(points)

# Closing the sketch to make it a continuous loop and extrude it
result = r.close().extrude(2)

# Exporting the result to an STL file
result.val().exportStl("Refine_V_1.stl")
