
import cadquery as cq

# Define the main rectangular body
result = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Specify the locations for the three holes in a triangular pattern
# Top hole at the center and bottom two holes distributed
hole_triangle_points = [(0, 0.4), (-1, -0.4), (1, -0.4)]

# Add holes to the rectangular object
result = result.faces(">Z").workplane().pushPoints(hole_triangle_points).hole(0.2)

# Save the STL file
result.val().exportStl("Refine_V_2.stl")
