
import cadquery as cq

# Dimensions
width = 20.0
height = width / 20  # Minimal height of the rectangle
square_side = width / 2  # Side of the first square
small_square_side = square_side * 0.99  # Slightly smaller than the first square
extrude_depth = width * 20  # Depth of extrusion

# Base rectangle
base = cq.Workplane("front").rect(width, height).extrude(extrude_depth)

# First square on top of the rectangle, positioned using moveTo
first_square = cq.Workplane("front").workplane(offset=height).transformed(offset=(width/4, square_side/2, 0)).rect(square_side, square_side).extrude(extrude_depth)

# Second smaller square on top of the first square
second_square = cq.Workplane("front").workplane(offset=height + square_side).transformed(offset=(width/4, square_side/2 - square_side*0.005, 0)).rect(small_square_side, small_square_side).extrude(extrude_depth)

# Combining the shapes
result = base.union(first_square).union(second_square)

# Export the STL file with the designated file name provided by the user
result.val().exportStl("Refine_V_1.stl")
