
import cadquery as cq

# Define the dimensions
rect_width = 10.0
rect_height = 5.0
tri_height = 5.0
cutout_size = 1.0
extrude_amount = 1.0

# Create the rectangle
result = cq.Workplane("front").rect(rect_width, rect_height)

# Add the triangle on top
result = result.moveTo(rect_width / 2.0, rect_height / 2.0).lineTo(-rect_width / 2.0, tri_height).lineTo(rect_width / 2.0, tri_height).close()

# Cutout the bottom corners
result = result.moveTo(-rect_width / 2.0, -rect_height / 2.0).lineTo(-rect_width / 2.0 + cutout_size, -rect_height / 2.0).lineTo(-rect_width / 2.0, -rect_height / 2.0 + cutout_size).close()
result = result.moveTo(rect_width / 2.0, -rect_height / 2.0).lineTo(rect_width / 2.0 - cutout_size, -rect_height / 2.0).lineTo(rect_width / 2.0, -rect_height / 2.0 + cutout_size).close()

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Generated.stl")
