
import cadquery as cq

# Define the dimensions
rect_width = 10.0
rect_height = 5.0
tri_height = 5.0
cutout_size = 1.0
extrude_amount = 1.0

# Create a new workplane
result = cq.Workplane("front")

# Create the main rectangle and position the triangle to form a pentagon
result = result.rect(rect_width, rect_height).extrude(extrude_amount)

# Create the triangle, connected to the rectangle
triangle = (
    cq.Workplane("front")
    .moveTo(0, rect_height / 2.0)
    .lineTo(rect_width / 2.0, rect_height / 2.0 + tri_height)
    .lineTo(-rect_width / 2.0, rect_height / 2.0 + tri_height)
    .close()
    .extrude(extrude_amount)
)

# Combine the rectangle and the triangle
result = result.union(triangle)

# Cut out the bottom-left corner
cutout1 = (
    cq.Workplane("front")
    .moveTo(-rect_width / 2.0, -rect_height / 2.0)
    .polyline([(-rect_width / 2.0 + cutout_size, -rect_height / 2.0), (-rect_width / 2.0, -rect_height / 2.0 + cutout_size)])
    .close()
    .extrude(extrude_amount)
)

# Cut out the bottom-right corner
cutout2 = (
    cq.Workplane("front")
    .moveTo(rect_width / 2.0, -rect_height / 2.0)
    .polyline([(rect_width / 2.0 - cutout_size, -rect_height / 2.0), (rect_width / 2.0, -rect_height / 2.0 + cutout_size)])
    .close()
    .extrude(extrude_amount)
)

# Subtract the cutouts from the main body
result = result.cut(cutout1).cut(cutout2)

# Save the result as STL
result.val().exportStl("Refine_V_2.stl")
