
import cadquery as cq

# Define dimensions based on the user's requirement
outer_size = 100.0  # size of the outer square
inner_size = 90.0   # size of the inner square which is smaller and fits inside the outer one
corner_radius = 10.0  # radius for rounding the corners of the square
extrude_height = 20.0  # height of extrusion for both the outer and inner constructs

# Create the outer square with rounded corners and extrude it to form the outer part of the mold
outer_square = (
    cq.Workplane("XY")
    .rect(outer_size, outer_size, forConstruction=True)
    .vertices()
    .fillet(corner_radius)  # Apply rounded corners
)

outer_part = outer_square.extrude(extrude_height)  # Extrude the outer square

# Work on the same plane and create an inner square on top of the outer part
# Then use it to cut out from the outer part to create a hollow interior
inner_square = (
    outer_part.faces(">Z")  # Select the top face of the extruded outer part
    .workplane()
    .rect(inner_of_inner_size, inner_size, forConstruction=True)
    .vertices()
    .fillet(corner_radius)  # Rounded corners for the inner square
)

# Use the inner square profile to cut through the outer part, creating a hollow with the same height
result = inner_square.cutBlumb(-extrude_height)

# Save the result as STL file as requested
result.val().exportStl("Refine_V_1.stl")
