
import cadquery as cq

# Set dimensions of the cinder block
block_width = 20.0
block_height = 10.0
block_depth = block_height / 4  # 1/4th of the height

# Dimensions of the holes
hole_width = block_width * 5 / 12  # 5/12th of the block's width
hole_height = block_height * 7 / 10  # 7/10th of the block's height
hole_radius = 1.0  # Radius for fillet corners

# Create the main block
block = cq.Workplane("front").rect(block_width, block_height).extrude(block_depth)

# Create holes with filleted (rounded) corners
holes = (
    cq.Workplane("front")
    .moveTo(-block_width / 4, 0)  # Position first hole
    .rect(hole_width, hole_height)
    .extrude(block_depth)
    .faces(">Z")  # Apply fillet on the top face
    .fillet(hole_radius)
)

# Mirror the first hole across the YZ plane to make it symmetrical
holes = holes.union(holes.mirror("YZ"))

# Subtract the holes from the block
result = block.cut(holes)

# Export the final model as STL
result.val().exportStl("Refine_V_1.stl")
