
import cadquery as cq

# Define dimensions
circle_diameter = 10.0
rectangle_width = 1.0
rectangle_height = 7.0 * rectangle_width  # Ensure the rectangle's height is 7 times its width
hole_diameter = 0.5
extrude_depth = 2.0

# Create a new workplane
result = cq.Workplane("front")

# Create the circular base
result = result.circle(circle_diameter / 2.0)

# Create the rectangle, ensuring its bottom edge touches the bottom of the circle
rectangle_placement_y = circle_diameter / 2.0 - rectangle_height / 2.0
result = result.workplane(offset=0) \
    .transformed(offset=(0, -rectangle_placement_y, 0)) \
    .rect(rectangle_width, rectangle_height, centered=False) 
    
# Adding a temperature indication line on the rectangle to represent it as a thermometer
result = result.moveTo(0, -rectangle_height / 2.0).lineTo(0, rectangle_height / 2.0)

# Add hole near the top edge of the rectangle
hole_placement_y = rectangle_placement_y + rectangle_height - hole_diameter / 2.0
result = result.workplane(offset=0) \
    .transformed(offset=(0, -hole_placement_y, 0)) \
    .circle(hole_diameter / 2.0)

# Combine all drawn shapes and extrude to form a 3D object
result = result.extrude(extrude_depth)

# Output the model as an STL file
result.val().exportStl("Refine_V_1.stl")
