
import cadquery as cq

# Define the dimensions for the parts of the T-shape
length_vertical = 100.0  # Length of the vertical rectangle
width = 20.0  # Width for both rectangles
thickness = 5.0  # Extrusion thickness
length_horizontal = length_vertical / 4  # Length of the horizontal rectangle, 1/4 of the vertical length

# Create the vertical part of the T-shape
result = cq.Workplane("front").rect(width, length_vertical).extrude(thickness)

# Specify the horizontal part's position closer to the top of the vertical part
# Adjust the horizontal rectangle to be at the top, less the half of its length to center it
horizontal_position = length_vertical / 2 - length_horizontal / 2

# Create the horizontal part of the T-shape
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").transformed(offset=(0, horizontal_position, 0)).rect(width, length_horizontal).extrude(thickness)

# Save the result to an STL file
result.val().exportStl("Refine_V_1.stl")
