
import cadquery as cq

# Points defining an irregular pentagon with the bottom edge significantly shorter
points = [(0, 0), (1, 1), (0.5, 3), (-0.5, 3), (-1, 1)]

# Create a Workplane to build on
r = cq.Workplane("front").polyline(points).close()

# Calculate an approximate height of the pentagon
pent_height = 3  # Max Y - Min Y from the points
extrusion_height = 2 * pent_height  # Extrusion height almost two times the pentagon height

# Extrude the pentagon
result = r.extrude(extrusion_height)

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
