
import cadquery as cq

# Establishing the dimensions for the box
base_width = 20.0
base_height = 10.0  # Ensuring height is exactly half of width
base_depth = 1.0
wall_thickness = 1.0
wall_height = 10.0
chamfer_size = 0.5   # adjust this value to the desired rounding

# Creating the base of the box
base = cq.Workplane("XY").rect(base_width, base_height).extrude(base_depth)

# Adding the walls
walls = (
    base.faces(">Z")  # select the top face of the base
    .workplane()     # start a new workplane from the face
    # Creating two concentric rectangles, inner one being offset by wall_thickness
    .rect(base_width, base_height)
    .rect(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness)
    .extrude(wall_height)  # extruding the walls upwards
)

# Adding chamfers to the inside corners for rounding
# Below, it selects only the inside vertical edges for chamfering
inner_corners = walls.edges("|Z")
walls = inner_corners.chamfer(chamfer_size)

# Combining the base and the walls to create the final box
box = base.union(walls)

# Exporting the refined model to an STL file
box.val().exportStl("Refine_V_2.stl")
