
import cadquery as cq

# Parameters for the 3D model
length = 10.0
width1 = 5.0
width2 = 3.0
height = 2.0
hole_diameter = 1.0

# Create the base rectangular block
result = cq.Workplane("XY").rect(length, width1).extrude(height)

# Add the second rectangle on top with the same length but smaller width
result = result.faces(">Z").workplane().rect(length, width2).extrude(height)

# Create a hole that passes through both rectangular blocks
# Ensure the hole is placed at the center of the top surface of the upper block, but it will extend through both
result = result.faces(">Z").workplane().center(0, (width1 - width2) / 2).circle(hole_diameter / 2).cutThruAll()

# Export the model as an STL file
result.val().exportStl("Refine_V_2.stl")
