
import cadquery as cq

# Define the dimensions of the table top and legs
table_length = 1.2
table_width = 0.56
table_thickness = 0.77
leg_length = 0.1
leg_width = 0.1
leg_height = 0.3649

# Create the table top
table_top = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the table legs
leg = cq.Workplane("XY").box(leg_length, leg_width, leg_height)
legs = (
    leg
    .translate((-table_length / 2, -table_width / 2, -leg_height))
    .union(leg.translate((table_length / 2, -table_width / 2, -leg_height)))
    .union(leg.translate((-table_length / 2, table_width / 2, -leg_height)))
    .union(leg.translate((table_length / 2, table_width / 2, -leg_height)))
)

# Combine the table top and legs
table = table_top.union(legs)

# Export the result
table.val().exportStl("Refine_1.stl")
