
import cadquery as cq

# Define the parameters of the annulus
outer_radius = 1.5
inner_radius = 0.75
thickness = 0.09

# Create the annulus
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Refine_1.stl")
