
import cadquery as cq

# Define the parameters of the rectangle
length = 0.71
width = 0.41
corner_radius = 0.1
depth = 0.22

# Create the rounded rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(depth) # extruding the rectangle to create a slab
)

# Apply rounded corners where possible
for edge in result.edges().vals():
    try:
        result = result.edges("%s" % edge).fillet(corner_radius)
    except:
        pass

# Move the center of the bounding box to the desired location
result = result.translate(cq.Vector(0.35, 0.20, 0.11))

# Export the result
result.val().exportStl("Refine_1.stl")
