
import cadquery as cq

# Update parameters for the ring
outer_radius = 3.0
inner_radius = 1.5
thickness = 0.1

# Create the ring
result_2 = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result to STL
result_2.val().exportStl("Refine_2.stl")
