
import cadquery as cq

# Parameters for the cylinder and hole
diameter = 1.5  # Diameter of the cylinder
height = 0.38  # Height of the cylinder
hole_diameter = 0.75  # Diameter of the hole

# Create the cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Export the result
result.val().exportStl("Refine_2.stl")
