
import cadquery as cq

# Create the first rectangle and extrude it
result = cq.Workplane("front").rect(10, 5).extrude(1)

# Create the second rectangle on top of the first one with slightly smaller widths
result = result.faces(">Z").workplane().rect(8, 5).extrude(1)

# Create the trapezoid on top of the second rectangle
result = result.faces(">Z").workplane().polyline([(0, 0), (7, 0), (9, 2), (-9, 2), (-7, 0)]).close().extrude(1)

# Save the output
result.val().exportStl("Generated.stl")
