
import cadquery as cq

# Create the first rectangle and extrude it
result = cq.Workplane("front").rect(1.4, 0.75).extrude(0.26)

# Create the second rectangle on top of the first one with slightly smaller widths
result = result.faces(">Z").workplane().rect(1.2, 0.75).extrude(0.26)

# Create the trapezoid on top of the second rectangle
result = result.faces(">Z").workplane().polyline([(0, 0), (1.1, 0), (1.3, 0.2), (-1.3, 0.2), (-1.1, 0)]).close().extrude(0.26)

# Save the output
result.val().exportStl("Refine_1.stl")
