
import cadquery as cq

# Create a short cylinder with a large diameter
cylinder = cq.Workplane("XY").circle(1.5).extrude(0.53)

# Create a short and narrow rectangular prism
rect_prism = cq.Workplane("XY").box(1.36, 0.54, 1.5)

# Translate the rectangular prism to sit on top of the cylinder
rect_prism = rect_prism.translate((0, 0, 0.75))

# Combine the two shapes
result = cylinder.union(rect_prism)

# Export the result
result.val().exportStl("Refine_2.stl")
