
import cadquery as cq

# Define dimensions
rectangle_length = 0.34
rectangle_width = 0.23
rectangle_thickness = 0.01
rod_width = 0.02
rod_length = 0.02
rod_height = 1.02

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Create the rod
result = (
    result
    .faces(">Z")
    .workplane()
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the result
result.val().exportStl("Refine_1.stl")
