
import cadquery as cq

# Define the dimensions
width = 0.36  # Width of the square
length = 2 * width  # Length of the square

# Create the square and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(0.34)  # Extrude the square to create a 3D object
)

# Save the output
result.val().exportStl("Refine_1.stl")
