
import cadquery as cq

# Create a workplane
result = cq.Workplane("front")

# Draw the outline of the plate
result = result.moveTo(-0.08, 0).lineTo(0.08, 0).threePointArc((0.085, 0.025), (0.08, 0.05)).lineTo(-0.08, 0.05).threePointArc((-0.085, 0.025), (-0.08, 0))

# Extrude it to create the plate
result = result.close().extrude(1.5)

# Create the holes
result = result.faces(">Z").workplane().center(0.07, 0.025).hole(0.01).center(-0.07, 0.025).hole(0.01)

# Export the refined result
result.val().exportStl("Refine_2.stl")
