
import cadquery as cq

# Define the dimensions of the plate and holes
plate_length = 1.16
plate_width = 0.07
plate_thickness = 1.5
hole_diameter = 0.05
hole_offset = 0.1

# Create the plate
result = (
    cq.Workplane("XY")
    .box(plate_length, plate_width, plate_thickness)
)

# Cut the holes
for offset in [-hole_offset, hole_offset]:
    result = (
        result.faces(">Z")
        .workplane()
        .center(offset, 0)
        .hole(hole_diameter)
    )

# Save the result
result.val().exportStl("Refine_2.stl")
