
import cadquery as cq

# Define the dimensions of the outer and inner squares
outer_size = 10.0
inner_size = 8.0
length = 20.0

# Create the outer square and extrude it
result = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(length)

# Create the inner square and extrude it negatively to create a hole
result = result.faces(">Y").workplane().rect(inner_size, inner_size).cutBlind(-length)

# Export the result
result.val().exportStl("Generated.stl")
