
import cadquery as cq

# Parameters for the pipe and flange
pipe_od = 15.0  # Outer diameter of the pipe
pipe_id = 8.0  # Inner diameter of the pipe
pipe_length = 50.0  # Length of the pipe
flange_od = 15.0  # Outer diameter of the flange
flange_thickness = 1.0  # Thickness of the flange

# Create the pipe
pipe = (
    cq.Workplane("XY")
    .circle(pipe_od / 2.0)
    .extrude(pipe_length)
    .faces("<Z")
    .workplane()
    .circle(pipe_id / 2.0)
    .cutThruAll()
)

# Create the flange
flange = (
    cq.Workplane("XY")
    .circle(flange_od / 2.0)
    .extrude(flange_thickness)
    .faces("<Z")
    .workplane()
    .circle(pipe_od / 2.0)
    .cutThruAll()
)

# Combine the pipe and flange
pipe_flange = pipe.union(flange)

# Export the result
pipe_flange.val().exportStl("Refine_2.stl")
