
import cadquery as cq

# Create a parallelogram
parallelogram = cq.Workplane("XY").polyline([(0, 0), (1.5, 0), (1.75, 0.43), (0.25, 0.43)]).close()

# Extrude the parallelogram
extruded = parallelogram.extrude(0.35)

# Draw a square inside the extruded parallelogram
square = extruded.faces(">Z").workplane().rect(0.75, 0.75)

# Negatively extrude the square to create a hole
result = square.cutThruAll()

# Save the output
result.val().exportStl("Refine_1.stl")
