
import cadquery as cq
import math

# Define the points of the pentagon
pts = [
    (0, 0),
    (2, 0),
    (2.5, 1),
    (2, 2),
    (0, 2),
    (-0.5, 1)
]

# Create the workplane and the pentagon
result = cq.Workplane("XY").polyline(pts).close()

# Extrude to create a 3D object
result = result.extrude(1)

# Export the result
result.val().exportStl("Generated.stl")
