
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Create a large annulus shape
result = result.circle(10).circle(5)

# Extrude the annulus shape
result = result.extrude(5)

# Select the bottom face of the cylinder
result = result.faces("<Z").workplane()

# Create a circle at the bottom of the cylinder to close it
result = result.circle(10).extrude(5)

# Save the output
result.val().exportStl("Generated.stl")
