
import cadquery as cq

# Create the base of the thermometer
base = cq.Workplane("XY").circle(0.01875).extrude(0.3375)

# Create the stem of the thermometer
stem = cq.Workplane("XY").moveTo(0, 0.3375).rect(0.01875, 0.3375).extrude(0.52)

# Combine the base and the stem
thermometer = base.union(stem)

# Export the result
thermometer.val().exportStl("Refine_2.stl")
