
import cadquery as cq

# Define the dimensions of the rectangle
length = 80.0
width = 60.0
thickness = 10.0

# Define the dimensions of the hole
hole_length = length / 8
hole_width = width / 8

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the hole
result = (
    result.faces(">Z")
    .workplane()
    .rect(hole_length, hole_width)
    .cutBlind(-thickness)
)

# Export the result
result.val().exportStl("Generated.stl")
