
import cadquery as cq

# Define the dimensions of the cylinders
d1, h1 = 10.0, 50.0  # diameter and height of the first cylinder
d2, h2 = d1 / 4, h1 / 8  # diameter and height of the second cylinder
d3, h3 = d2 / 2, h2 * 2  # diameter and height of the third cylinder

# Create the first cylinder
result = cq.Workplane("XY").circle(d1 / 2).extrude(h1)

# Create the second cylinder, offset from the center of the first
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").center(0, -d1 / 4).circle(d2 / 2).extrude(h2)

# Create the third cylinder, concentric with the second
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").circle(d3 / 2).extrude(h3)

# Export the result
result.val().exportStl("Refine_2.stl")
