
import cadquery as cq

# Create a sketch of a rectangle
rectangle = cq.Workplane("XY").rect(1.5, 0.8)

# Extrude the rectangle
extruded_rectangle = rectangle.extrude(0.24)

# Add a circular hole at the center of the rectangle
result = extruded_rectangle.faces(">Z").workplane().hole(0.1)

# Save the output
result.val().exportStl("Refine_2.stl")
