
import cadquery as cq

# Define dimensions
length = 80.0  # Length of the rectangle
width = 20.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
square_size = length / 16  # Size of the square
square_thickness = thickness / 3  # Thickness of the square

# Create the rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the squares
for i in [-1, 1]:
    result = (
        result
        .faces(">Z")
        .workplane(centerOption="CenterOfBoundBox")
        .center(i * length / 4, 0)
        .rect(square_size, square_size)
        .extrude(square_thickness)
    )

# Export the result
result.val().exportStl("Generated.stl")
