
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 0.15), (0.75, 0.15), (0.75, 0.14), (0.01, 0.14), (0.01, 0)]

# Create a workplane and draw the L shape using the polyline function
result = cq.Workplane("front").polyline(points).close()

# Extrude the L shape to create the 3D bracket
result = result.extrude(0.3)

# Export the result to an STL file
result.val().exportStl("Refine_1.stl")
