
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Draw the outer circle
result = result.circle(0.5)

# Draw the inner circle at a shifted position
result = result.circle(0.25).translate((0.125, 0, 0))

# Extrude the crescent shape
result = result.extrude(0.75)

# Export the result
result.val().exportStl("Refine_2.stl")
