
import cadquery as cq

# Define the dimensions of the book
book_thickness = 20.0
book_width = 100.0
book_height = 200.0

# Create an obtuse angled sketch for the book
sketch = (cq.Workplane('XY')
            .polyline([(0, 0), 
                       (book_width, 0), 
                       (book_width, book_height), 
                       (0, book_height)])
           .close())

# Extrude the sketch to get the 3D model of the book
book = sketch.extrude(book_thickness)

# Export the result
book.val().exportStl("Refine_2.stl")
