
import cadquery as cq

# Parameters for the square block and the pipe
block_size = 10.0
block_height = 10.0
pipe_outer_radius = 2.0
pipe_inner_radius = 1.5
pipe_height = 9.0

# Create the square block
result = cq.Workplane("XY").box(block_size, block_size, block_height)

# Create the hole in the block
result = result.faces(">Z").workplane().hole(2*pipe_inner_radius)

# Create the pipe
result = result.faces(">Z").workplane().circle(pipe_outer_radius).circle(pipe_inner_radius).extrude(pipe_height)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
