
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_small_base = 5.0
trap_large_base = rect_length
extrude_amount = 20.0

# Create the rectangle
result = cq.Workplane("XY").rect(rect_length, rect_width)

# Create the trapezoid
result = result.workplane(offset=rect_width).moveTo(0, -rect_width/2).line(trap_small_base/2, 0).line(0, trap_height).line(-(trap_large_base), 0).line(0, -trap_height).close()

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_1.stl")
