
import cadquery as cq

# Define the dimensions
width = 90.0
height = 60.0
depth = 30.0
cutout_size = width / 3.0

# Create the large rectangle
result = cq.Workplane("front").rect(width, height).extrude(depth)

# Create the square cutout
result = result.faces(">Z").workplane().rect(cutout_size, cutout_size).extrude(-depth/2)

# Save the output
result.val().exportStl("Refine_2.stl")
