
import cadquery as cq

# Define dimensions
square_size = 1.1
extrusion_height = 1.31
inner_square_size = 0.67
inner_extrusion_height = 0.21
circle_diameter = 0.1
circle_extrusion_height = 0.21
small_circle_diameter = 0.05
small_circle_extrusion_height = 0.21
small_circle_offset = 0.33

# Create the outer square and extrude it
result = cq.Workplane("XY").box(square_size, square_size, extrusion_height)

# Hollow out the inside of the square
result = result.faces(">Z").workplane().rect(inner_square_size, inner_square_size).cutBlind(-inner_extrusion_height)

# Create the large circle at the bottom of the square
result = result.faces("<Z").workplane().circle(circle_diameter / 2).extrude(circle_extrusion_height)

# Create the four smaller circles at the corners of the square
for x in [-1, 1]:
    for y in [-1, 1]:
        result = result.faces(">Z").workplane().center(x * small_circle_offset, y * small_circle_offset).circle(small_circle_diameter / 2).extrude(small_circle_extrusion_height)

# Export the result
result.val().exportStl("Refine_2.stl")
