
import cadquery as cq

# Create a square and slightly extrude it
result = cq.Workplane("XY").rect(10, 10).extrude(1)

# Create four tiny circular holes, positioning each one near a corner
result = result.faces(">Z").workplane().pushPoints([(4, 4), (-4, 4), (4, -4), (-4, -4)]).hole(0.5)

# Create a hollow cylinder and extrude it, positioning it so that it intersects the square in the middle
result = result.faces(">Z").workplane().circle(2).cutBlind(-1)

# Export the result
result.val().exportStl("Refine_2.stl")
