
import cadquery as cq

# Create a sketch of a rectangle
sketch = cq.Workplane("front").box(10, 5, 0.5)

# Cutout two small rectangles from the bottom left and bottom right corners
cut1 = cq.Workplane("front").workplane(offset=-0.25).moveTo(-5, -2.5).rect(1, 1).extrude(0.5)
cut2 = cq.Workplane("front").workplane(offset=-0.25).moveTo(5, -2.5).rect(1, 1).extrude(0.5)

# Cut the two small rectangles from the original sketch
result = sketch.cut(cut1).cut(cut2)

# Save the output
result.val().exportStl("Refine_2.stl")
