
import cadquery as cq

# Define the dimensions of the table
table_length = 10.0
table_width = 4.0
table_height = 1.0
leg_width = 1.5
leg_height = 4.0

# Create the table top
table_top = cq.Workplane("XY").box(table_length, table_width, table_height)

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(-table_length / 2 + leg_width / 2, -table_width / 2 + leg_width / 2)
    .box(leg_width, leg_width, leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(table_length / 2 - leg_width / 2, -table_width / 2 + leg_width / 2)
    .box(leg_width, leg_width, leg_height)
)
leg3 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(-table_length / 2 + leg_width / 2, table_width / 2 - leg_width / 2)
    .box(leg_width, leg_width, leg_height)
)
leg4 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(table_length / 2 - leg_width / 2, table_width / 2 - leg_width / 2)
    .box(leg_width, leg_width, leg_height)
)

# Combine all the parts
result = table_top.union(leg1).union(leg2).union(leg3).union(leg4)

# Export the result
result.val().exportStl("Refine_1.stl")
