
import cadquery as cq

# Define the dimensions of the table
table_length = 10.0
table_width = 4.0
table_height = 1.0
leg_width = 2.0
leg_height = 6.0
distance_legs = leg_width / 2

# Create the table top
table_top = cq.Workplane("XY").box(table_length, table_width, table_height).translate((0, 0, leg_height))

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .box(leg_width, leg_width, leg_height)
    .translate((-table_length / 2 + distance_legs, -table_width / 2 + distance_legs, leg_height / 2))
)
leg2 = (
    cq.Workplane("XY")
    .box(leg_width, leg_width, leg_height)
    .translate((table_length / 2 - distance_legs, -table_width / 2 + distance_legs, leg_height / 2))
)
leg3 = (
    cq.Workplane("XY")
    .box(leg_width, leg_width, leg_height)
    .translate((-table_length / 2 + distance_legs, table_width / 2 - distance_legs, leg_height / 2))
)
leg4 = (
    cq.Workplane("XY")
    .box(leg_width, leg_width, leg_height)
    .translate((table_length / 2 - distance_legs, table_width / 2 - distance_legs, leg_height / 2))
)

# Combine all the parts
result = table_top.union(leg1).union(leg2).union(leg3).union(leg4)

# Export the result
result.val().exportStl("Refine_2.stl")
