
import cadquery as cq
import math

# Parameters for the pipe
outer_radius = 10.0
inner_radius = 8.0
height = 20.0
angle = 60.0  # Angle to cut out from the pipe

# Create the outer cylinder
pipe = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder
pipe = pipe.cut(inner)

# Create a rectangular box
rect = cq.Workplane('XY').rect(2*outer_radius, 2*outer_radius).extrude(height)

# Create a wedge to cut out the sector
wedge = cq.Workplane('XY').polygon(3, 2 * outer_radius).extrude(height).rotate((0,0,0), (0,0,1), 180 - angle/2)

# Subtract the wedge from the box
cutout = rect.cut(wedge)

# Subtract the cutout from the pipe
pipe = pipe.cut(cutout)

# Save the output
pipe.val().exportStl("Refine_2.stl")
