
import cadquery as cq

# Create the base cylinder
result = cq.Workplane("XY").circle(20.0).extrude(30.0)

# Create the smaller cylinder on top of the base cylinder
result = result.faces(">Z").workplane().circle(10.0).extrude(20.0)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
