
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 0.33), (0.67, 0.33), (0.67, 0.31), (0.02, 0.31), (0.02, 0)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Close the polyline and extrude to create the bracket
result = r.close().extrude(0.75)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
