
#Correcting the dimeansions in the points[]
#Also changing the size of extrusion
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 2), (1.5, 2), (1.5, 1.5), (0.5, 1.5), (0.5, 0)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Close the polyline and extrude to create the bracket
result = r.close().extrude(1)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
