
import cadquery as cq

# Create a rectangular block
result = cq.Workplane("XY").box(10, 2, 0.5)

# Create three holes in a triangular formation
result = result.faces(">Z").workplane().pushPoints([(0, 0), (-1, -1), (1, -1)]).hole(0.2)

# Export the result
result.val().exportStl("Refine_2.stl")
